/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp;

import com.aptana.core.io.efs.VirtualFile;
import com.aptana.core.io.vfs.IConnectionFileManager;
import com.aptana.filesystem.ftp.IFTPConnectionFileManager;
import com.aptana.filesystem.ftp.internal.FTPConnectionFileManager;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FTPFileSystem
extends FileSystem {
    private static Map<String, IFTPConnectionFileManager> fgConnectionManagers = new WeakHashMap<String, IFTPConnectionFileManager>();

    public IFileStore getStore(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String userInfo = uri.getUserInfo();
        String login = "";
        char[] password = "".toCharArray();
        if (userInfo != null && userInfo.length() > 0) {
            if (userInfo.contains(":")) {
                String[] parts = userInfo.split(":");
                login = parts[0];
                if (parts.length > 1) {
                    password = parts[1].toCharArray();
                }
            } else {
                login = userInfo;
            }
        }
        if (login == null || login.length() == 0) {
            login = "anonymous";
        }
        if (port == -1) {
            port = 21;
        }
        IFTPConnectionFileManager connectionFileManager = this.getConnectionFileManager(host, port, path, login, password);
        return new VirtualFile((IConnectionFileManager)connectionFileManager, uri, Path.fromPortableString((String)path));
    }

    protected synchronized IFTPConnectionFileManager getConnectionFileManager(String host, int port, String path, String login, char[] password) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(login);
        if (password != null && password.length > 0) {
            stringBuilder.append(':');
            stringBuilder.append(password);
        }
        stringBuilder.append('@');
        stringBuilder.append(host);
        stringBuilder.append(':');
        stringBuilder.append(port);
        String key = stringBuilder.toString();
        IFTPConnectionFileManager connectionFileManager = fgConnectionManagers.get(key);
        if (connectionFileManager == null) {
            ConnectionContext context;
            connectionFileManager = (IFTPConnectionFileManager)super.getAdapter(IFTPConnectionFileManager.class);
            if (connectionFileManager == null && Platform.getAdapterManager().hasAdapter((Object)this, IFTPConnectionFileManager.class.getName())) {
                connectionFileManager = (IFTPConnectionFileManager)Platform.getAdapterManager().loadAdapter((Object)this, IFTPConnectionFileManager.class.getName());
            }
            if (connectionFileManager == null) {
                connectionFileManager = new FTPConnectionFileManager();
            }
            if ((context = CoreIOPlugin.getConnectionContext((Object)((Object)this))) == null) {
                context = new ConnectionContext();
            }
            context.put((Object)"no_password_prompt", (Object)true);
            context.put((Object)"quick_connect", (Object)true);
            CoreIOPlugin.setConnectionContext((Object)connectionFileManager, (ConnectionContext)context);
            connectionFileManager.init(host, port, (IPath)Path.ROOT, login, password, true, "BINARY", "US-ASCII", null);
            fgConnectionManagers.put(key, connectionFileManager);
        }
        return connectionFileManager;
    }
}

